#!/usr/bin/env python
#-*- coding: UTF-8 -*-

import dataparser

dataparser = dataparser.DataParser("/nfs/data/duldul/wulj/publicsource/table_particle.dt", [2 for i in range(50)])

class Particle():
	"""
  Particle Attributes:

    @ available after initialization
      getMass() / getWidth() / getCharge() / getSpin() / getLift() / getLund() / getName() / getID() / getIndex()

    @ available after setMother(ptc) or setChild(ptc)
      getMother(i) / getChild(i)/ getChildren() / getMothers() / getNChildren() / getNMothers() / getRelationTo(ptc):

    @ available after setProperties(**kwargs)
      getProperties() / getProperty(key)
	"""

	def __init__(self, id = 0, index = -1):
		""" 
      different particle has to be different id or index in a event
		"""
		global dataparser
		self.m_data = dataparser
		self.m_id, self.m_index = id, index

		self.m_mothers, self.m_children = list(), list()
		self.m_properties = dict()

	def getMass(self):   return float(self.m_data.getData(self.m_id, "mass"))
	def getWidth(self):  return float(self.m_data.getData(self.m_id, "width"))
	def getCharge(self): return float(self.m_data.getData(self.m_id, "charge3")) / 3.0
	def getSpin(self): return float(self.m_data.getData(self.m_id, "spin2")) / 2.0
	def getLife(self): return float(self.m_data.getData(self.m_id, "life"))
	def getLund(self): return float(self.m_data.getData(self.m_id, "Lund"))
	def getName(self): return self.m_data.getData(self.m_id, "name")
	def getID(self):   return self.m_id
	def getIndex(self): return self.m_index

	def setMother(self, ptc): self.m_mothers.append(ptc)
	def setChild(self, ptc): self.m_children.append(ptc)

	def getMother(self, i = 0): return self.m_mothers[i]
	def getChild(self, i): return self.m_children[i]
	def getChildren(self): return self.m_children
	def getMothers(self): return self.m_mothers
	def getNChildren(self): return len(self.m_children)
	def getNMothers(self): return len(self.m_mothers)

	def getRelationTo(self, ptc):
		"""
      param ptc type is Particle
      return relationship with ptc: mother, child, none
         A.getRelationTo(B): A is B's mother, child, or none
		"""
		if ((ptc.getID(), ptc.getIndex()) in self.getMothersIDIndex()) or ((self.getID(), self.getIndex()) in ptc.getChildrenIDIndex()) : return "child"
		if ((ptc.getID(), ptc.getIndex()) in self.getChildrenIDIndex()) or ((self.getID(), self.getIndex()) in ptc.getMothersIDIndex()): return "mother"
		return "none"

	def setProperties(self, **kwargs):
		for key in kwargs:
			self.m_properties[key] = kwargs[key]

	def getProperties(self):
		"""
      return added property dict
		"""
		return self.m_properties
	def getProperty(self, key):
		"""
      return added property with key
		"""
		return self.m_properties[key]

	#def isSameWith(self, ptc):
	#	return ([self.getID(), self.getIndex()] == [ptc.getID(), ptc.getIndex()]) and  \
  #    sorted(self.m_mother_id_index, key = lambda x: (x[0], x[1])) == sorted(ptc.m_mother_id_index, key = lambda x: (x[0], x[1])) and \
  #    sorted(self.m_child_id_index, key = lambda x: (x[0], x[1])) == sorted(ptc.m_child_id_index, key = lambda x: (x[0], x[1])) and \
  #    self.m_properties == ptc.m_properties
