//************************************************************************//
//									  //
//  Copyright 2013 Bertram Kopf (bertram@ep1.rub.de)			  //
//  	      	   Julian Pychy (julian@ep1.rub.de)			  //
//          	   - Ruhr-Universität Bochum 				  //
//									  //
//  This file is part of Pawian.					  //
//									  //
//  Pawian is free software: you can redistribute it and/or modify	  //
//  it under the terms of the GNU General Public License as published by  //
//  the Free Software Foundation, either version 3 of the License, or 	  //
//  (at your option) any later version.	 	      	  	   	  //
//									  //
//  Pawian is distributed in the hope that it will be useful,		  //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of	  //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	  //
//  GNU General Public License for more details.	      		  //
//									  //
//  You should have received a copy of the GNU General Public License     //
//  along with Pawian.  If not, see <http://www.gnu.org/licenses/>.	  //
//									  //
//************************************************************************//

// KMatrixBase class definition file. -*- C++ -*-
// Copyright 2012 Bertram Kopf

#pragma once 

//_____________________________________________________________________________
// @file KMatrixBase.h
//_____________________________________________________________________________

#include "qft++/matrix/Matrix.hh"
#include <iostream>
#include <vector>
#include <boost/shared_ptr.hpp>
#include "PwaDynamics/AbsPhaseSpace.hh"

class KPole;


using namespace std;
//_____________________________________________________________________________
//_____________________________________________________________________________

class KMatrixBase : public Matrix< complex<double> > {

public:

  /// Constructor 
  KMatrixBase(vector<boost::shared_ptr<KPole> > Kpoles, vector<boost::shared_ptr<AbsPhaseSpace> > phpVecs); 
  KMatrixBase(vector<boost::shared_ptr<AbsPhaseSpace> > phpVecs, int numCols, int numRows);
  KMatrixBase(int numCols, int numRows); 
  /// Destructor
  virtual ~KMatrixBase();

  virtual void evalMatrix(const double mass) {return;}
  virtual vector<boost::shared_ptr<AbsPhaseSpace> > phaseSpaceVec() {return _phpVecs;}
  virtual vector<boost::shared_ptr<KPole> > kpoles() {return _KPoles;}

protected:
  vector<boost::shared_ptr<KPole> > _KPoles;
  vector<boost::shared_ptr<AbsPhaseSpace> > _phpVecs;
};
//_____________________________________________________________________________


