#include "Event/Event.hh"
#include <vector>

Event::Event() : weight(1.),
  evtNo(0)
{}
Event::Event(int evtNumber) : 
  weight(1.),
  evtNo(evtNumber)
{}
Event::~Event()
{
  std::vector<EvtPartData*>::iterator iter;
  for (iter = particles.begin(); iter != particles.end(); ++iter)
    delete *iter;
}
  
Vector4<float>* Event::p4(unsigned int i)
{
  if (particles.size() > i)
    return particles[i]->vector4;
  else {
    Alert << "accessing " << i << "th of " 
	  << particles.size() << " particles" << endmsg;
    exit(1);
  }
  return 0;
}


float* Event::pid(unsigned int i)
{
  if (particles.size() > i)
    return particles[i]->pidVector;
  else {
    Alert << "accessing pid of " << i << "th of " 
	  << particles.size() << " particles" << endmsg;
    exit(1);
  }
}


void Event::addParticle(double e, double px, double py, double pz)
{
  EvtPartData* evtData = new EvtPartData(e,px,py,pz);
  particles.push_back(evtData);
  return;
}

void Event::addWeight(double theWeight)
{
  weight = theWeight;
}

int Event::size()
{
  return particles.size();
}

bool Event::operator<(const Event& compare) const{
  bool result=false;
  if ( evtNo < compare.eventNo()) result=true;
  return result;
}
