// Includes all headers in relativistic-quantum-mechanics directory -*- C++ -*-
/* Copyright 2008 Mike Williams (mwill@jlab.org)
 *
 * This file is part of qft++.
 *
 * qft++ is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * qft++ is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with qft++.  If not, see <http://www.gnu.org/licenses/>.
 */
//_____________________________________________________________________________
/** @file include/relativistic-quantum-mechanics.h
 *  @brief File to be included for access to entire relativistic-quantum-mechanics package.
 */
//_____________________________________________________________________________
#ifndef _include_relativistic_quantum_mechanics_H
#define _include_relativistic_quantum_mechanics_H
//_____________________________________________________________________________

#include "qft++/relativistic-quantum-mechanics/Spin.hh"
#include "qft++/relativistic-quantum-mechanics/Utils.hh"
#include "qft++/relativistic-quantum-mechanics/PolVector.hh"
#include "qft++/relativistic-quantum-mechanics/OrbitalTensor.hh"
#include "qft++/relativistic-quantum-mechanics/DiracMatricies.hh"
#include "qft++/relativistic-quantum-mechanics/DiracSpinor.hh"
#include "qft++/relativistic-quantum-mechanics/DiracAntiSpinor.hh"

//_____________________________________________________________________________
#endif /* _include_relativistic_quantum_mechanics_H */
