//************************************************************************//
//									  //
//  Copyright 2017 Bertram Kopf (bertram@ep1.rub.de)			  //
//          	   - Ruhr-Universität Bochum 				  //
//									  //
//  This file is part of Pawian.					  //
//									  //
//  Pawian is free software: you can redistribute it and/or modify	  //
//  it under the terms of the GNU General Public License as published by  //
//  the Free Software Foundation, either version 3 of the License, or 	  //
//  (at your option) any later version.	 	      	  	   	  //
//									  //
//  Pawian is distributed in the hope that it will be useful,		  //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of	  //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	  //
//  GNU General Public License for more details.	      		  //
//									  //
//  You should have received a copy of the GNU General Public License     //
//  along with Pawian.  If not, see <http://www.gnu.org/licenses/>.	  //
//									  //
//************************************************************************//

// PiPiScatteringChannelEnv class definition file. -*- C++ -*-
// Copyright 2017 Bertram Kopf


#pragma once

#include "PwaUtils/DataUtils.hh"
#include "PwaUtils/AbsChannelEnv.hh"

class pipiScatteringParser;
class Particle;

class PiPiScatteringChannelEnv : public AbsChannelEnv{

public:
  virtual void setupChannel(ChannelID id);
  PiPiScatteringChannelEnv(pipiScatteringParser* thePiPiScatteringParser);

  virtual const std::string  channelTypeName() {return "pipiScattering";}

  std::string pathToKMatrixParser() {return _pathKMatrixParserFile;}
  virtual std::shared_ptr<AbsHist> CreateHistInstance(std::string additionalSuffix="", bool withTruth=false);
  //  virtual void addPiPiScatteringDynamics();
protected:
  virtual void setupGlobal(ChannelID id);
  virtual void addDynamics();
  pipiScatteringParser* _thePiPiScatteringParser;
  std::string _pathKMatrixParserFile;
};
