//************************************************************************//
//									  //
//  Copyright 2013 Bertram Kopf (bertram@ep1.rub.de)			  //
//  	      	   Julian Pychy (julian@ep1.rub.de)			  //
//          	   - Ruhr-Universität Bochum 				  //
//									  //
//  This file is part of Pawian.					  //
//									  //
//  Pawian is free software: you can redistribute it and/or modify	  //
//  it under the terms of the GNU General Public License as published by  //
//  the Free Software Foundation, either version 3 of the License, or 	  //
//  (at your option) any later version.	 	      	  	   	  //
//									  //
//  Pawian is distributed in the hope that it will be useful,		  //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of	  //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	  //
//  GNU General Public License for more details.	      		  //
//									  //
//  You should have received a copy of the GNU General Public License     //
//  along with Pawian.  If not, see <http://www.gnu.org/licenses/>.	  //
//									  //
//************************************************************************//

// pbarpBaseLh class definition file. -*- C++ -*-
// Copyright 2012 Bertram Kopf

#pragma once

#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <complex>
#include <memory>
#include <boost/function.hpp>

#include "qft++/topincludes/relativistic-quantum-mechanics.hh"

#include "PwaUtils/AbsLh.hh"
#include "PwaUtils/AbsChannelEnv.hh"
#include "PwaUtils/DataUtils.hh"
#include "Minuit2/MnUserParameters.h"

class AbsXdecAmp;
class pbarpReaction;
class LSDecAmps;

class pbarpBaseLh : public AbsLh {

public:
  // pbarpBaseLh(std::shared_ptr<const EvtDataBaseList>);

  pbarpBaseLh(ChannelID channelID);

  virtual ~pbarpBaseLh();

  virtual AbsLh* clone_() const =0;

  virtual double calcEvtIntensity( EvtData* theData, fitParams& theParamVal);
  virtual complex<double> calcProdPartAmp(Spin lamX, Spin lamDec, std::string nameDec, EvtData* theData,
					  std::map <std::shared_ptr<const JPCLS>,
					  std::vector< std::shared_ptr<AbsXdecAmp> >,
					  pawian::Collection::SharedPtrLess > pbarpAmps);

virtual complex<double> calcSpinDensity(Spin M1, Spin M2, std::string& nameDec, EvtData* theData, int J);
virtual double calcSpinDensityNorm(std::string& nameDec, EvtData* theData, int J);

  virtual void getDefaultParams(fitParams& fitVal, fitParams& fitErr);
  virtual void updateFitParams(fitParams& theParamVal);

  virtual void print(std::ostream& os) const;

protected:
  ChannelID _channelID;
  std::shared_ptr<pbarpReaction> _pbarpReactionPtr;
  std::vector< std::shared_ptr<const JPCLS> > _jpclsStates;
  std::vector< std::shared_ptr<const IGJPC> > _igjpcStates;

  std::map <std::shared_ptr<const JPCLS>, std::vector< std::shared_ptr<AbsXdecAmp> >, pawian::Collection::SharedPtrLess > _decAmpsSinglet;
  std::map <std::shared_ptr<const JPCLS>, std::vector< std::shared_ptr<AbsXdecAmp> >, pawian::Collection::SharedPtrLess > _decAmpsTriplet0;
  std::map <std::shared_ptr<const JPCLS>, std::vector< std::shared_ptr<AbsXdecAmp> >, pawian::Collection::SharedPtrLess > _decAmpsTripletp1;
  std::map <std::shared_ptr<const JPCLS>, std::vector< std::shared_ptr<AbsXdecAmp> >, pawian::Collection::SharedPtrLess > _decAmpsTripletm1;

  std::map< std::shared_ptr<const jpcRes>, double, pawian::Collection::SharedPtrLess > _currentParamIsos;
  std::map< std::shared_ptr<const JPCLS>, double, pawian::Collection::SharedPtrLess > _currentParamMags;
  std::map< std::shared_ptr<const JPCLS>, double, pawian::Collection::SharedPtrLess > _currentParamPhis;

  std::map< std::shared_ptr<const jpcRes>, double, pawian::Collection::SharedPtrLess> _currentParamJPCIsos1;
  std::map< std::shared_ptr<const jpcRes>, double, pawian::Collection::SharedPtrLess> _currentParamJPCIsos0;

  std::vector< std::shared_ptr<AbsXdecAmp> > _iso0DecAmps;
  std::vector< std::shared_ptr<AbsXdecAmp> > _iso1DecAmps;
  //  std::map< std::shared_ptr<AbsXdecAmp>, std::shared_ptr<AbsXdecAmp>, pawian::Collection::SharedPtrLess > _iso0Iso1DecAmpMap;
  std::map<std::string, std::pair<std::string, std::string> > _iso0Iso1NameMap;
  int _highestJFsp;
  bool _isHighestJaPhoton;

  virtual void fillMap(std::vector< std::shared_ptr<const JPCLS> >& pbarpLSs, std::vector<std::shared_ptr<AbsXdecAmp> >& decs, std::map< std::shared_ptr<const JPCLS>, std::vector<std::shared_ptr<AbsXdecAmp> >, pawian::Collection::SharedPtrLess >& toFill);

  virtual void fillIsos();

private:

  void initialize();
};
