/**
 * @file cacertificates.h
 *
 * @author Tobias Triffterer
 *
 * @brief Retrieve Certificates from Qt Resources
 *
 * Rutherford Experiment Lab Course Online
 * Copyright © 2021 Ruhr-Universität Bochum, Institut für Experimentalphysik I
 * https://www.ep1.ruhr-uni-bochum.de/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

#include <QDir>

#include "cacertificates.h"

static void initResourcesOutsideNamespace()
{
#ifdef LIBFP311ONLINE_LOAD_DEVEL_CERT_RESOURCE
    Q_INIT_RESOURCE(devel_cert);
#endif
}

using namespace Fp311Online;

QList<QSslCertificate> CaCertificates::getCaCertificatesFromResource()
{
    static bool initializedResource = false;
    if (!initializedResource) {
        initResourcesOutsideNamespace();
        initializedResource = true;
    }

    return QSslCertificate::fromPath(
               QStringLiteral(":/crypto/*.pem"),
               QSsl::Pem,
               QRegExp::Wildcard
           );
}
