/**
 * @file rootcanvaswidget.h
 *
 * @author Tobias Triffterer
 *
 * @brief Qt Widget to host a ROOT Canvas
 *
 * Rutherford Experiment Lab Course Online
 * Copyright © 2021 Ruhr-Universität Bochum, Institut für Experimentalphysik I
 * https://www.ep1.ruhr-uni-bochum.de/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

/**
 * The code in this class has been inspired by the following ROOT forum thread
 * https://root-forum.cern.ch/t/gvirtualx-addwindow-problem/25215/5
 * and this example posted there:
 * https://root-forum.cern.ch/uploads/default/original/2X/4/4f1f5269962b0622a04fa6093c805f5573669df4.gz
 **/

#ifndef LIBFP311ONLINE_ROOTCANVASWIDGET_H
#define LIBFP311ONLINE_ROOTCANVASWIDGET_H

#include <memory>

#include <QMouseEvent>
#include <QPaintEvent>
#include <QResizeEvent>
#include <QWidget>

#include <TCanvas.h>

#include "fp311online_export.h"

namespace Fp311Online
{

class FP311ONLINE_EXPORT RootCanvasWidget : public QWidget
{
    Q_OBJECT

public:
    RootCanvasWidget(QWidget* const parent = 0);
    ~RootCanvasWidget() = default;
    RootCanvasWidget(const RootCanvasWidget& other) = delete;
    RootCanvasWidget(RootCanvasWidget&& other) = delete;
    RootCanvasWidget& operator=(const RootCanvasWidget& other) = delete;
    RootCanvasWidget& operator=(RootCanvasWidget&& other) = delete;

    TCanvas* getCanvas() const;

    bool ignoreUserInput() const;
    void setIgnoreUserInput(const bool ignore);
protected:
    void resizeEvent(QResizeEvent* const event) override;
    void paintEvent(QPaintEvent* const event) override;
    void mouseMoveEvent(QMouseEvent* const event) override;
    void mousePressEvent(QMouseEvent* const event) override;
    void mouseReleaseEvent(QMouseEvent* const event) override;
private:
    std::unique_ptr<TCanvas> _canvas;
    bool _ignoreUserInput;
};

}
#endif // LIBFP311ONLINE_ROOTCANVASWIDGET_H
