#
# @file versioning.cmake
#
# @author Tobias Triffterer
#
# Rutherford Experiment Lab Course Online
# Copyright © 2021 Ruhr-Universität Bochum, Institut für Experimentalphysik I
# https://www.ep1.ruhr-uni-bochum.de/
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

# Find Git for Git-based versioning
find_package(Git QUIET)

if (Git_FOUND)
  # Determine version number from Git Revision
  execute_process(COMMAND "${GIT_EXECUTABLE}" describe --always --tags --abbrev=8 --dirty WORKING_DIRECTORY "${CURRENT_SOURCE_DIR}" RESULT_VARIABLE GIT_VERSION_RESULT OUTPUT_VARIABLE GIT_VERSION ERROR_QUIET OUTPUT_STRIP_TRAILING_WHITESPACE)
  if (DEFINED ENV{CI_COMMIT_REF_NAME})
     # We are running inside the GitLab CI where the branch name is in the environment variable
     # but git is in detached head state so "git rev-parse" will not work.
    set(GIT_BRANCH "$ENV{CI_COMMIT_REF_NAME}+gitlab-ci")
    set(GIT_BRANCH_RESULT 0)
  else()
    execute_process(COMMAND "${GIT_EXECUTABLE}" rev-parse --abbrev-ref HEAD WORKING_DIRECTORY "${CURRENT_SOURCE_DIR}" RESULT_VARIABLE GIT_BRANCH_RESULT OUTPUT_VARIABLE GIT_BRANCH ERROR_QUIET OUTPUT_STRIP_TRAILING_WHITESPACE)
  endif (DEFINED ENV{CI_COMMIT_REF_NAME})
endif(Git_FOUND)

# Fall back to version.txt if no git data is available
if (
     (NOT "${GIT_VERSION_RESULT}" EQUAL 0)
     OR
     (NOT "${GIT_BRANCH_RESULT}" EQUAL 0)
     OR
     (NOT DEFINED GIT_VERSION)
     OR
     (NOT DEFINED GIT_BRANCH)
     OR
     ("${GIT_VERSION}" STREQUAL "")
     OR
     ("${GIT_BRANCH}" STREQUAL "")
  )
  file(STRINGS ${SOURCE_DIR}/version.txt GIT_VERSION)
  set(GIT_BRANCH "[standalone]")
endif()
if ("${GIT_BRANCH}" STREQUAL "HEAD")
  set(GIT_BRANCH "[detached HEAD]")
endif ("${GIT_BRANCH}" STREQUAL "HEAD")

# Write version information into source code file
configure_file("${CURRENT_SOURCE_DIR}/src/version.libfp311online.cpp.in" "${CURRENT_BINARY_DIR}/version.libfp311online.cpp" @ONLY)

message(STATUS "Detected libfp311online version ${GIT_VERSION} from branch ${GIT_BRANCH}")
