#
# @file build-root-submodule.cmake
#
# @author Tobias Triffterer
#
# Rutherford Experiment Lab Course Online
# Copyright © 2021 Ruhr-Universität Bochum, Institut für Experimentalphysik I
# https://www.ep1.ruhr-uni-bochum.de/
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

function(AddRootLibraryTarget)
  cmake_parse_arguments(ARLT 0 "LIBNAME" "DEPENDENCIES" ${ARGN})

  if (NOT DEFINED ARLT_LIBNAME OR "${ARLT_LIBNAME}" EQUAL "")
    message(FATAL_ERROR "Library Name not specified in AddRootLibraryTarget")
  endif (NOT DEFINED ARLT_LIBNAME OR "${ARLT_LIBNAME}" EQUAL "")
  set(LIBNAME "${ARLT_LIBNAME}")

  if (NOT EXISTS "${PROJECT_BINARY_DIR}/root_install/lib/lib${LIBNAME}.so.${ROOT_MAJOR_VERSION}.${ROOT_MINOR_VERSION}.${ROOT_PATCH_VERSION}")
    message(FATAL_ERROR "Cannot find ROOT library ${LIBNAME} at ${PROJECT_BINARY_DIR}/root_install/lib/lib${LIBNAME}.so.${ROOT_MAJOR_VERSION}.${ROOT_MINOR_VERSION}.${ROOT_PATCH_VERSION}")
  endif (NOT EXISTS "${PROJECT_BINARY_DIR}/root_install/lib/lib${LIBNAME}.so.${ROOT_MAJOR_VERSION}.${ROOT_MINOR_VERSION}.${ROOT_PATCH_VERSION}")

  add_library(ROOT::${LIBNAME} SHARED IMPORTED)
  set_target_properties(ROOT::${LIBNAME} PROPERTIES
    INTERFACE_COMPILE_FEATURES "cxx_std_${CMAKE_CXX_STANDARD}"
    INTERFACE_INCLUDE_DIRECTORIES "${PROJECT_BINARY_DIR}/root_install/include"
  )

  set_property(TARGET ROOT::${LIBNAME} APPEND PROPERTY IMPORTED_CONFIGURATIONS RELWITHDEBINFO)
  set_target_properties(ROOT::${LIBNAME} PROPERTIES
    IMPORTED_LOCATION_RELWITHDEBINFO "${PROJECT_BINARY_DIR}/root_install/lib/lib${LIBNAME}.so.${ROOT_MAJOR_VERSION}.${ROOT_MINOR_VERSION}.${ROOT_PATCH_VERSION}"
    IMPORTED_SONAME_RELWITHDEBINFO "lib${LIBNAME}.so.${ROOT_MAJOR_VERSION}.${ROOT_MINOR_VERSION}"
  )

  add_dependencies(ROOT::${LIBNAME} ROOTexternalProject)

  # Make ROOT-internal dependencies known to CMake
  if (DEFINED ARLT_DEPENDENCIES)
    foreach(DEPLIBNAME IN LISTS ARLT_DEPENDENCIES)
      target_link_libraries(ROOT::${LIBNAME} INTERFACE ROOT::${DEPLIBNAME})
    endforeach(DEPLIBNAME IN LISTS ARLT_DEPENDENCIES)
  endif(DEFINED ARLT_DEPENDENCIES)
endfunction(AddRootLibraryTarget LIBNAME)

include(ExternalProject)

ExternalProject_Add(
  ROOTexternalProject
  SOURCE_DIR "${PROJECT_SOURCE_DIR}/submodules/root"
  BINARY_DIR "${PROJECT_BINARY_DIR}/root_build"
  INSTALL_DIR "${PROJECT_BINARY_DIR}/root_install"
  CMAKE_ARGS -DCMAKE_C_COMPILER=${CMAKE_C_COMPILER} -DCMAKE_CXX_COMPILER=${CMAKE_CXX_COMPILER} -DCMAKE_CXX_STANDARD=${CMAKE_CXX_STANDARD} -DCMAKE_BUILD_TYPE=RelWithDebInfo -DCMAKE_INSTALL_PREFIX=<INSTALL_DIR>
  CMAKE_CACHE_ARGS -Dalien:BOOL=OFF -Darrow:BOOL=OFF -Dbuiltin_xrootd:BOOL=OFF -Dcefweb:BOOL=OFF -Dcuda:BOOL=OFF -Ddavix:BOOL=OFF -Dfcgi:BOOL=OFF -Dfftw3:BOOL=OFF -Dfortran:BOOL=OFF -Dgminimal:BOOL=ON -Dhttp:BOOL=OFF -Dmathmore:BOOL=OFF -Dminuit2:BOOL=ON -Dmpi:BOOL=OFF -Dmysql:BOOL=OFF -Dodbc:BOOL=OFF -Dpgsql:BOOL=OFF -Dpyroot:BOOL=OFF -Dpythia8:BOOL=OFF -Droofit:BOOL=ON -Dsoversion:BOOL=ON -Dspectrum:BOOL=OFF -Dssl:BOOL=OFF -Dtmva:BOOL=OFF -Dvmc:BOOL=OFF -Dx11:BOOL=ON -Dxml:BOOL=OFF -Dxproofd:BOOL=OFF -Dxrootd:BOOL=OFF
)
  
file(READ ${PROJECT_SOURCE_DIR}/submodules/root/build/version_number versionstr)
string(STRIP ${versionstr} versionstr)
string(REGEX REPLACE "([0-9]+)[.][0-9]+[/][0-9]+" "\\1" ROOT_MAJOR_VERSION ${versionstr})
string(REGEX REPLACE "[0-9]+[.]([0-9]+)[/][0-9]+" "\\1" ROOT_MINOR_VERSION ${versionstr})
string(REGEX REPLACE "[0-9]+[.][0-9]+[/]([0-9]+)" "\\1" ROOT_PATCH_VERSION ${versionstr})
set(ROOT_VERSION "${ROOT_MAJOR_VERSION}.${ROOT_MINOR_VERSION}.${ROOT_PATCH_VERSION}" PARENT_SCOPE)
set(ROOT_MAJOR_VERSION "${ROOT_MAJOR_VERSION}" PARENT_SCOPE)
set(ROOT_MINOR_VERSION "${ROOT_MINOR_VERSION}" PARENT_SCOPE)
set(ROOT_PATCH_VERSION "${ROOT_PATCH_VERSION}" PARENT_SCOPE)
  
AddRootLibraryTarget(LIBNAME Core)
AddRootLibraryTarget(LIBNAME Thread DEPENDENCIES Core)
AddRootLibraryTarget(LIBNAME MathCore DEPENDENCIES Core)
AddRootLibraryTarget(LIBNAME RIO DEPENDENCIES Core Thread)
AddRootLibraryTarget(LIBNAME Matrix DEPENDENCIES MathCore)
AddRootLibraryTarget(LIBNAME Net DEPENDENCIES RIO)
AddRootLibraryTarget(LIBNAME Tree DEPENDENCIES Net RIO MathCore)
AddRootLibraryTarget(LIBNAME Hist DEPENDENCIES MathCore Matrix RIO)
AddRootLibraryTarget(LIBNAME Graf DEPENDENCIES Hist Matrix MathCore RIO)
AddRootLibraryTarget(LIBNAME Gpad DEPENDENCIES Graf Hist)
AddRootLibraryTarget(LIBNAME Foam DEPENDENCIES Hist MathCore)
AddRootLibraryTarget(LIBNAME Minuit DEPENDENCIES Graf Hist Matrix MathCore)
AddRootLibraryTarget(LIBNAME Minuit2 DEPENDENCIES MathCore Hist)
AddRootLibraryTarget(LIBNAME HistPainter DEPENDENCIES Gpad Graf Hist MathCore Matrix)
AddRootLibraryTarget(LIBNAME Smatrix DEPENDENCIES Core MathCore)
AddRootLibraryTarget(LIBNAME RooFitCore DEPENDENCIES Core Hist Graf Matrix Tree Minuit RIO MathCore Foam Smatrix)
AddRootLibraryTarget(LIBNAME RooFit DEPENDENCIES Core RooFitCore Tree RIO Matrix MathCore)
