/**
 * @file clilogger.cpp
 *
 * @author Tobias Triffterer
 *
 * @brief Central Interface for Log Output
 *
 * Rutherford Experiment Lab Course Online
 * Copyright © 2021 Ruhr-Universität Bochum, Institut für Experimentalphysik I
 * https://www.ep1.ruhr-uni-bochum.de/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

#include <iostream>

#include <QDateTime>

#include "clilogger.h"

using namespace Fp311Online;

void CliLogger::writeLogEntry(const QString& component, const LogLevel loglevel, const QString& message)
{
    std::cout << "\033[";
    switch (loglevel) {
        case LogLevel::Error:
            std::cout << "91";
            break;
        case LogLevel::Warning:
            std::cout << "93";
            break;
        case LogLevel::Info:
            std::cout << "94";
            break;
        case LogLevel::Debug:
        default:
            std::cout << "0";
            break;
    }
    std::cout << "m";
    std::cout << QDateTime::currentDateTime().toString(Qt::DateFormat::ISODate).toUtf8().constData();
    std::cout << " <";
    switch (loglevel) {
        case LogLevel::Error:
            std::cout << "ERROR";
            break;
        case LogLevel::Warning:
            std::cout << "WARNING";
            break;
        case LogLevel::Info:
            std::cout << "INFO";
            break;
        case LogLevel::Debug:
            std::cout << "DEBUG";
            break;
        default:
            std::cout << "UNKNOWN";
            break;
    }
    std::cout << "> [" << component.toUtf8().constData() << "]: ";
    std::cout << message.toUtf8().constData();
    std::cout << "\033[0m" << std::endl;
}

CliLogger::ComponentLogger CliLogger::createComponentLogger(const QString& component, const LogLevel loglevel)
{
    return std::bind(&CliLogger::writeLogEntry, component, loglevel, std::placeholders::_1);
}
