/**
 * @file command.h
 *
 * @author Tobias Triffterer
 *
 * @brief Struct handling Protocol Commands
 *
 * Rutherford Experiment Lab Course Online
 * Copyright © 2021 Ruhr-Universität Bochum, Institut für Experimentalphysik I
 * https://www.ep1.ruhr-uni-bochum.de/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

#ifndef LIBFP311ONLINE_COMMAND_H
#define LIBFP311ONLINE_COMMAND_H

#include <QHash>
#include <QJsonObject>
#include <QString>

#include "action.h"
#include "clilogger.h"
#include "fp311online_export.h"

namespace Fp311Online
{

namespace Protocol
{

struct FP311ONLINE_EXPORT Command {
public:
    using Arguments = QHash<QString, QString>;
    using Token = QString;

    Action action {Action::invalid};
    Arguments arguments {};
    Token token {};

    static Command fromString(const QString& source);
    QString toString() const;

    Command(const Action _action, const Arguments& _arguments, const Token& _token)
        : action(_action),
          arguments(_arguments),
          token(_token)
    {}

    Command() = default;
    ~Command() = default;
    Command(const Command& other) = default;
    Command(Command&& other) = default;
    Command& operator=(const Command& other) = default;
    Command& operator=(Command&& other) = default;

private:
    static Action parseActionString(const QString& string);

    static Command parseAuthenticate(const QJsonObject& input);
    static Command parseStoreToken(const QJsonObject& input);
    static Command parseError(const QJsonObject& input);
    static Command parseUpdateExperimentState(const QJsonObject& input);
    static Command parseSetTargetState(const QJsonObject& input);
    static Command parseFillHistogram(const QJsonObject& input);

    static QString getActionString(const Action action);
};

}

}

#endif // LIBFP311ONLINE_COMMAND_H
