/**
 * @file cacertificates.h
 *
 * @author Tobias Triffterer
 *
 * @brief Retrieve Certificates from Qt Resources
 *
 * Rutherford Experiment Lab Course Online
 * Copyright © 2021 Ruhr-Universität Bochum, Institut für Experimentalphysik I
 * https://www.ep1.ruhr-uni-bochum.de/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

#ifndef LIBFP311ONLINE_CACERTIFICATES_H
#define LIBFP311ONLINE_CACERTIFICATES_H

#include <QList>
#include <QSslCertificate>

namespace Fp311Online
{

class CaCertificates
{
public:
    static QList<QSslCertificate> getCaCertificatesFromResource();

    CaCertificates() = delete;
    ~CaCertificates() = delete;
    CaCertificates(const CaCertificates& other) = delete;
    CaCertificates(CaCertificates&& other) = delete;
    CaCertificates& operator=(const CaCertificates& other) = delete;
    CaCertificates& operator=(CaCertificates&& other) = delete;
};

}

#endif // LIBFP311ONLINE_CACERTIFICATES_H
