/**
 * @file clilogger.h
 *
 * @author Tobias Triffterer
 *
 * @brief Central Interface for Log Output
 *
 * Rutherford Experiment Lab Course Online
 * Copyright © 2021 Ruhr-Universität Bochum, Institut für Experimentalphysik I
 * https://www.ep1.ruhr-uni-bochum.de/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

#ifndef LIBFP311ONLINE_CLILOGGER_H
#define LIBFP311ONLINE_CLILOGGER_H

#include <functional>

#include <QString>

#include "fp311online_export.h"

namespace Fp311Online
{

enum class LogLevel {
    Error,
    Warning,
    Info,
    Debug,
};

class FP311ONLINE_EXPORT CliLogger
{
public:
    using ComponentLogger = std::function<void(QString)>;

    static void writeLogEntry(const QString& component, const LogLevel loglevel, const QString& message);
    static ComponentLogger createComponentLogger(const QString& component, const LogLevel loglevel);

    CliLogger() = delete;
    ~CliLogger() = delete;
    CliLogger(const CliLogger& other) = delete;
    CliLogger(CliLogger&& other) = delete;
    CliLogger& operator=(const CliLogger& other) = delete;
    CliLogger& operator=(CliLogger&& other) = delete;
};

}

#endif // LIBFP311ONLINE_CLILOGGER_H
