/**
 * @file legalstuff.cpp
 *
 * @author Tobias Triffterer
 *
 * @brief Dialog for Legal and Licensing Information
 *
 * Rutherford Experiment Lab Course Online
 * Copyright © 2021 Ruhr-Universität Bochum, Institut für Experimentalphysik I
 * https://www.ep1.ruhr-uni-bochum.de/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

#include <QFile>
#include <QtGlobal>

#include <TROOT.h>

#include "version.fp311online-client.h"
#include "version.libfp311online.h"
#include "legalstuff.h"

using namespace Fp311Online;

LegalStuff::LegalStuff(QWidget* const parent)
    : QDialog(parent)
{
    _ui.setupUi(this);
    connect(_ui.bbLeave, &QDialogButtonBox::accepted, this, &QDialog::close);

    QString legalText = QStringLiteral("<html>\n<body>\n");
    legalText.append(
        getResourceContent(QStringLiteral(":/legal/legal-infos.htmlpart"))
        .arg(QString::fromUtf8(Fp311OnlineClientVersion.c_str()))
        .arg(QString::fromUtf8(LibFp311OnlineVersion.c_str()))
        .arg(QString::fromUtf8(qVersion()))
        .arg(QString::fromUtf8(gROOT->GetVersion()))
    );
    legalText.append(QStringLiteral("<hr />\n"));
    legalText.append(getResourceContent(QStringLiteral(":/legal/gpl3.htmlpart")));
    legalText.append(QStringLiteral("<hr />\n"));
    legalText.append(getResourceContent(QStringLiteral(":/legal/lgpl3.htmlpart")));
    legalText.append(QStringLiteral("<hr />\n"));
    legalText.append(getResourceContent(QStringLiteral(":/legal/lgpl2.1.htmlpart")));
    legalText.append(QStringLiteral("</body>\n</html>\n"));

    _ui.lblInformation->setText(legalText);
}

QString LegalStuff::getResourceContent(const QString& fileName)
{
    QFile resource(fileName);
    resource.open(QFile::ReadOnly);
    if (!resource.isOpen())
        return QString();
    return QString::fromUtf8(resource.readAll());
}
