/**
 * @file legalstuff.h
 *
 * @author Tobias Triffterer
 *
 * @brief Dialog for Legal and Licensing Information
 *
 * Rutherford Experiment Lab Course Online
 * Copyright © 2021 Ruhr-Universität Bochum, Institut für Experimentalphysik I
 * https://www.ep1.ruhr-uni-bochum.de/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

#ifndef LEGALSTUFF_H
#define LEGALSTUFF_H

#include <QDialog>

#include "ui_legalstuff.h"

namespace Fp311Online
{

class LegalStuff : public QDialog
{
    Q_OBJECT

public:
    LegalStuff(QWidget*const parent = nullptr);
    ~LegalStuff() = default;
    LegalStuff(const LegalStuff& other) = delete;
    LegalStuff(LegalStuff&& other) = delete;
    LegalStuff& operator=(const LegalStuff& other) = delete;
    LegalStuff& operator=(LegalStuff&& other) = delete;
private:
    Ui::Fp311OnlineClientLegalStuff _ui {};
};

}

#endif // LEGALSTUFF_H
