/**
 * @file logingui.h
 *
 * @author Tobias Triffterer
 *
 * @brief Client Login Window
 *
 * Rutherford Experiment Lab Course Online
 * Copyright © 2021 Ruhr-Universität Bochum, Institut für Experimentalphysik I
 * https://www.ep1.ruhr-uni-bochum.de/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

#ifndef LOGINGUI_H
#define LOGINGUI_H

#include <memory>

#include <QMainWindow>
#include <QWebSocket>

#include "clilogger.h"
#include "ui_logingui.h"

namespace Fp311Online
{

class LoginGui : public QMainWindow
{
    Q_OBJECT

public:
    LoginGui();
    ~LoginGui() = default;
    LoginGui(const LoginGui& other) = delete;
    LoginGui(LoginGui&& other) = delete;
    LoginGui& operator=(const LoginGui& other) = delete;
    LoginGui& operator=(LoginGui&& other) = delete;

private:
    static const constexpr int LightnessThresholdForWhiteLogo = 100;

    Ui::Fp311OnlineClientLogin _ui {};
    std::unique_ptr<QWebSocket> _socket {};

    void doLogin();
    void sendAuthenticateMessage();
    void receivedMessageFromServer(const QString& message);
    void openClientGui(const QString name, const QString token);
    void socketError(QAbstractSocket::SocketError error);

    void showLegalStuff();

    const CliLogger::ComponentLogger logError = CliLogger::createComponentLogger(QStringLiteral("LoginGui"), LogLevel::Error);
    const CliLogger::ComponentLogger logWarning = CliLogger::createComponentLogger(QStringLiteral("LoginGui"), LogLevel::Warning);
    const CliLogger::ComponentLogger logInfo = CliLogger::createComponentLogger(QStringLiteral("LoginGui"), LogLevel::Info);
    const CliLogger::ComponentLogger logDebug = CliLogger::createComponentLogger(QStringLiteral("LoginGui"), LogLevel::Debug);
};

}

#endif // LOGINGUI_H
