# :warning: :construction: Under Construction :construction: :warning:

The project is in its early stages right now, so please come back later...

# Fp311Online Client Application

## About

Client application of the project to simulate the setup of the Advanced Lab Course for Physics Students on the Rutherford Experiment (F-Praktikum Physik Versuch 311 – Rutherford-Experiment) at the [Faculty of Physics and Astronomy](https://www.physik.ruhr-uni-bochum.de/) at [Ruhr-Universität Bochum](https://www.ruhr-uni-bochum.de/).

Using this software, students can still complete this lab course despite of the Covid-19 pandemic which makes working on the physical setup at the university impossible.

The client and server part of Fp311Online share a lot of code, which is thus been put into a common library that is integrated as a Git submodule and CMake subdirectory into this application.  
It's Git repository can be found here: https://gitlab.ep1.rub.de/fp311online/libfp311online

## License

This application is free software, it is licensed under the terms and conditions of the [GNU General Public License (GPL) as published by the Free Software Foundation, either version 3](https://www.gnu.org/licenses/gpl-3.0.html) of the GPL or — at your option — any later version.

## Build Requirements

* GNU C and C++ Compiler, version 8 or higher
  * Alternatively, Clang version 7 or higher should work, but has not been tested
* GNU Toolchain or compatible (`ld`, `make`, etc.)
* CMake, version 3.13 or higher
* Qt 5.12 or higher, including header files and tools
* ROOT version 6.16 or higher, if host ROOT installation is used
* Dependencies for ROOT, if the ROOT submodule is built (see https://root.cern/install/dependencies/ for details):
  * `libX11` and development headers
  * `libxpm` and development headers
  * `libxft` and development headers
  * `libxext` and development headers
  * `libpng` and development headers
  * `libjpeg` and development headers
  * Python, version 2.7 or higher
  * `libssl` and development headers

## Build Instructions

To compile the application, first clone the Git repository:

```bash
git clone --recurse-submodules https://gitlab.ep1.rub.de/fp311online/fp311online-client.git
```

Create a build directory and enter it:

```bash
mkdir build-fp311online-client
cd build-fp311online-client
```

If you have a [ROOT](https://root.cern) installation on your computer that can be discovered by CMake, you can use it.
To do this, execute:

```bash
cmake -DUSE_HOST_ROOT_INSTALL=ON -DCMAKE_CXX_STANDARD={14|17|20|...} ../path/to/fp311online-client
```

Fp311Online uses C++17 by default, but you may have to change it to the C++ standard your ROOT installation was compiled with, otherwise you may get compilation errors.

The libfp311online repository contains a modified ROOT version as a submodule. To compile this version of ROOT and libfp311online based on it, execute:

```bash
cmake -DUSE_HOST_ROOT_INSTALL=OFF ../path/to/fp311online-client
```

In both cases, after CMake has sucessfully prepared the build system, run

```bash
make
```

to do the actual compilation.
Please be advised that compiling ROOT from scratch can take a lot of time depending on the speed of the machine.
You can add the parameter `-jN` with `N` being a natural number to run `N` compilation steps in parallel.

## Instructions to Create a Flatpak Bundle

Flatpak is the main distribution path of this application as it is distribution-agnostic.

To create a Flatpak bundle, a working installation of `flatpak` and `flatpak-builder` is required.

Inside the Flatpak ecosystem, version `5.15` of the KDE runtime environment `org.kde.Platform` and the KDE software development kit (SDK) `org.kde.Sdk` is required.
Please note that Fp311Online does not depend on Plasma, the desktop environment made by KDE, but the [KDE Project](https://kde.org) maintains the SDK for building applications based on Qt with Flatpak.

To download and install these prerequisites, execute:

```bash
flatpak remote-add --if-not-exists flathub https://flathub.org/repo/flathub.flatpakrepo
flatpak install org.kde.Platform//5.15
flatpak install org.kde.Sdk//5.15
```

Depending on your system, it may be necessary to prefix each command with `sudo` to let it run with administrator/root rights.

The build process within Flatpak is controlled by a Flatpak manifest.
The [Fp311Online Resources Repository](https://gitlab.ep1.rub.de/fp311online/resources) contains the manifest for the client application that has to be downloaded:  
https://gitlab.ep1.rub.de/fp311online/resources/-/blob/master/flatpak/fp311online-client.flatpak.yml

To initiate the build process, create a directory where the files created while building can be stored.
(Any content of this directory will be wiped, so please be careful.)

The command to run the compilation inside Flatpak is:

```bash
flatpak-builder --force-clean $builddir path/to/fp311online-client.flatpak.yml
```

This command will take some time, as it compiles ROOT from source.
The hidden directory `.flatpak-builder` is created during the process, it contains a Flatpak repository from which the final bundle can be exported:

```bash
flatpak build-bundle .flatpak-builder/cache fp311online-client.flatpak de.ruhr_uni_bochum.ep1.tobias.fp311online.client
```

After this command has finished, the file `fp311online-client.flatpak` can be distributed.

## Open Source Frameworks used by this Application

This project uses code from other open source projects.
Under their respective licenses, you have the right to access their source code and distribute unmodified as well as modified versions of them.

### Qt

[Qt](https://qt.io) is a cross-platform C++ framework developed by “The Qt Company” to build graphical applications.
It is used in this software to create the user interface and to handle the client/server communication via the websockets protocol.

This application and the common library use the modules “Core“, “Gui“, “Widgets“, “Network”, and “WebSockets“ from Qt. All of them are licensend under the [GNU Lesser General Public License (LGPL), version 3](https://www.gnu.org/licenses/lgpl-3.0.html).

If you use the Flatpak build of this application, Qt is not shipped with the Flatpak bundle, but is part of the Flatpak runtime environment `org.kde.Platform`, see [the Flatpak webpage](https://docs.flatpak.org/en/latest/available-runtimes.html) for details.
The source code can be accessed on the GitLab installation of the KDE Project:

* https://invent.kde.org/packaging/flatpak-kde-runtime
* https://invent.kde.org/qt/qt

If you compiled this application from source, the Qt libraries and header files installed on your computer are used.
Please consult your distributor for access to the source code of these libraries.

### ROOT

[ROOT](https://root.cern) is a data analysis framework developed by [CERN](https://home.cern).
It is used in Fp311Online to generate the events on the server and display and fit the histogram on the client.

ROOT is licensed under the terms of the [GNU Lesser General Public License (LGPL), version 2.1](https://www.gnu.org/licenses/old-licenses/lgpl-2.1.html) or later.

This project has a modified version of ROOT to make it run (better) inside the Flatpak sandbox.
The source code of this modified version is available on the GitLab of Institut für Experimentalphysik I:  
https://gitlab.ep1.rub.de/fp311online/cern-root

The source code of the original ROOT project can be found on GitHub: https://github.com/root-project/root

When run outside of the Flatpak sandbox, this application can also use the unmodified version of ROOT. Inside the sanbox, unmodified versions should work, but the startup performance may be reduced.

## Contact

Dr. Tobias Triffterer

Ruhr-Universität Bochum  
Institut für Experimentalphysik I  
NB 2/126 – Fach-Nr. 125  
Universitätsstraße 150  
44801 Bochum  
Germany  

E-Mail: tobias@ep1.ruhr-uni-bochum.de  
[S/MIME Certificate](https://ep1.ruhr-uni-bochum.de/~tobias/tobias_ep1.pem) (Fingerprint: DF35 4C01 A72C E689 2D95  F52D 8426 5187 BE21 2DEE)  
[GnuPG/OpenPGP Key](https://ep1.ruhr-uni-bochum.de/~tobias/tobias_ep1.asc) (Fingerprint: 32FC 7266 0504 437B BF8A AFB6 7B74 849A 85A6 0E50)  

Matrix-ID: [\@trifftmp:ruhr-uni-bochum.de](https://matrix.to/#/@trifftmp:ruhr-uni-bochum.de)

This project has a public Matrix room: [#physikfp311online:ruhr-uni-bochum.de](https://matrix.to/#/#physikfp311online:ruhr-uni-bochum.de)
