/**
 * @file main.cpp
 *
 * @author Tobias Triffterer
 *
 * @brief Entry Point of the Application
 *
 * Rutherford Experiment Lab Course Online
 * Copyright © 2021 Ruhr-Universität Bochum, Institut für Experimentalphysik I
 * https://www.ep1.ruhr-uni-bochum.de/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

#include <iostream>

#include <QApplication>
#include <QLocale>
#include <QTranslator>

#include <TApplication.h>
#include <TROOT.h>

#include "logingui.h"
#include "version.fp311online-client.h"
#include "version.libfp311online.h"

using namespace Fp311Online;

int main(int argc, char** argv)
{
    std::cout << std::endl;
    std::cout << "Rutherford Experiment Lab Course Online (Fp311Online)" << std::endl;
    std::cout << std::endl;
    std::cout << "An Application to simulate the setup of the Rutherford Experiment Advanced Physics" << std::endl;
    std::cout << "Lab Course (F-Praktikum Physik Versuch 311) at Ruhr-Universität Bochum." << std::endl;
    std::cout << std::endl;
    std::cout << "This is version " << Fp311OnlineClientVersion << " of the Fp311Online client application from branch " << Fp311OnlineClientGitBranch << std::endl;
    std::cout << "using version " << LibFp311OnlineVersion << " of the Fp311Online common library from branch " << LibFp311OnlineGitBranch << std::endl;
    std::cout << "and using ROOT version " << gROOT->GetVersion() << "." << std::endl;
    std::cout << std::endl;
    std::cout << "Copyright © 2021 Ruhr-Universität Bochum, Institut für Experimentalphysik I" << std::endl;
    std::cout << "This is free software; see the source for copying conditions (GPLv3). There is NO" << std::endl;
    std::cout << "warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE." << std::endl;
    std::cout << "Dies ist freie Software; die Kopierbedingungen (GPLv3) stehen in den Quellen. Es" << std::endl;
    std::cout << "gibt KEINE Garantie; auch nicht für MARKTGÄNGIGKEIT oder FÜR SPEZIELLE ZWECKE.\n" << std::endl;

    QApplication app(argc, argv);
    app.setOrganizationName(QStringLiteral("Ruhr-Universität Bochum, Institut für Experimentalphysik I"));
    app.setOrganizationDomain(QStringLiteral("ep1.ruhr-uni-bochum.de"));
    app.setApplicationName(QStringLiteral("de.ruhr_uni_bochum.ep1.tobias.fp311online.client"));
    app.setApplicationDisplayName(QStringLiteral("Rutherford Experiment Lab Course Online (Fp311Online)"));
    app.setApplicationVersion(QString::fromUtf8(Fp311OnlineClientVersion.c_str()));

    QTranslator translator;
    if (translator.load(
                QLocale::system(),
                QStringLiteral("fp311online"),
                QStringLiteral("-"),
                QStringLiteral(":/l10n/"),
                QStringLiteral(".qm")
            ))
        app.installTranslator(&translator);

    TApplication rootapp("Fp311Online Client", &argc, argv);

    LoginGui logingui;
    logingui.show();

    return app.exec();
}
